import misc.Debug;
import java.util.Vector;
import java.util.Enumeration;
import java.awt.Image;
import types.Rahmen;
import types.FrameBuffer;
import types.Transaction;



public class Channel extends SystemObject {
    public Computer stationA;
    public Computer stationB;
    public FrameBuffer   inA;
    public FrameBuffer   inB;
    public Image    m_Image;
    public int      m_iSpeed;
    public int      m_iCountStep;
    int                 m_iMode;
    double              m_dDestroyP;
    public Channel() {
        m_iCountStep = 0;
        m_iMode = 0;
        m_dDestroyP = 0.05;
    };
    public void init(Image img,Computer a,Computer b) {
        stationA = a;
        stationB = b;
        m_Image=img;
        inA = new FrameBuffer();
        inB = new FrameBuffer();
    }
    public void sendFrame(Computer computer,Rahmen frame) {
        if (computer==stationA) {
           inA.addElement(frame);
        }
        if (computer==stationB) {
           inB.addElement(frame);
        }
    }
    public void model(int iModel) {
        m_iMode=iModel;
    }
    public int model() {
        return(m_iMode);
    }
    public void clearChannel() {
        inA.removeAllElements();
        inB.removeAllElements();
    }
    public synchronized void setSpeed(int iSpeed) {
        m_iSpeed = iSpeed;
    }
    public synchronized int getSpeed() {
        return(m_iSpeed);
    }
    public void nextStep() {
        m_iCountStep++;
   		// A new Timestep happens, initialize it
   		Transaction t = new Transaction();
        // filter frames (destroy)
   		filterFrames();
   		//
   		int iRememberB = inB.size();
       	// Transport frames
        for (Enumeration e = inA.elements();e.hasMoreElements();) {
            Rahmen frame=(Rahmen)e.nextElement();
            t.addAtoB(frame);
            if (!frame.Destroyed()) {
	            Debug.out("Data Seq Nummer:"+Integer.toString(frame.seqNr())+" OK");
                stationB.lowerLayerReceive(frame);
            }
            else {
	            Debug.out("Data Seq Nummer:"+Integer.toString(frame.seqNr())+" Destroyed");
            }
        }
        inA.removeAllElements();
        if (inB.size()!=iRememberB) {
            Global.historyPanel.addTransaction(t);
       		Global.historyPanel.addWindow(stationA.protocol().sendWindow,
                            stationB.protocol().receiveWindow);
       		t = new Transaction();
        }
        for (Enumeration e = inB.elements();e.hasMoreElements();) {
            Rahmen frame=(Rahmen)e.nextElement();
            t.addBtoA(frame);
            if (!frame.Destroyed()) {
	            Debug.out("Ack Seq Nummer:"+Integer.toString(frame.seqNr())+" OK");
                stationA.lowerLayerReceive(frame);
            }
            else {
	            Debug.out("Seq Nummer Channel:"+Integer.toString(frame.seqNr())+"Destroyed");
            }
        }
        inB.removeAllElements();
        // Add new Timestep to history Panel, if any transction happend
        if (t.size()>0) {
            Global.historyPanel.addTransaction(t);
       		Global.historyPanel.addWindow(stationA.protocol().sendWindow,
                            stationB.protocol().receiveWindow);
            ((ChannelPanel)panel()).myUpdate();
   		}
    }
    void filterFrames() {
        switch (m_iMode) {
        case 0: // Error free model
            break;
        case 1: // Propability p
            for (Enumeration e = inA.elements();e.hasMoreElements();) {
                Rahmen frame = (Rahmen) e.nextElement();
                double dWert = Math.random();
                if (dWert<m_dDestroyP) {
                    frame.Destroy();
                    if (frame.iKind()==Rahmen.DATA) {
                    }
                    else {
                    }
                }
            }
            for (Enumeration e = inB.elements();e.hasMoreElements();) {
                Rahmen frame = (Rahmen) e.nextElement();
                double dWert = Math.random();
                if (dWert<m_dDestroyP) {
                    frame.Destroy();
                    if (frame.iKind()==Rahmen.DATA) {
                    }
                    else {
                    }
                }
            }
            break;
        }
    }


}

